// GpPenEscL.cpp : implementation file
//

#include "stdafx.h"
#include "defsfile.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscL Dialog


CGpPenEscL::CGpPenEscL(CWnd* pParent /*=NULL*/)
	:CIndecateLine(CGpPenEscL::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpPenEscL)
	m_cLineStyle = 0 ;
	//}}AFX_DATA_INIT

	m_bAction = FALSE ;

	Create(IDD,pParent);
}


void CGpPenEscL::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpPenEscL)
	DDX_CBIndex(pDX, IDC_cLineStyle, m_cLineStyle);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGpPenEscL, CDialog)
	//{{AFX_MSG_MAP(CGpPenEscL)
		// 
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscL Message Handler

void CGpPenEscL::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	delete this ;
}

// Create Content
CContents*  CGpPenEscL::CreateContents()
{
	// Create empty content
	CContentsEscL* pContents = new CContentsEscL();

	// Set the data from dialog
	UpdateData(TRUE);
	pContents->m_Data.cDisplayColor = theApp.m_cDisplayColor  ;
	pContents->m_Data.cBackColor = theApp.m_cBackColor  ;

	// Line Style
	pContents->m_Data.cLineStyle = m_cLineStyle ;

	// Set Content the display position
	pContents->m_Data.iX1 = m_iX1 ;
	pContents->m_Data.iY1 = m_iY1 ;
	pContents->m_Data.iX2 = m_iX2 ;
	pContents->m_Data.iY2 = m_iY2 ;
	return( pContents );
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Draw Line
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Erase drawing
void CIndecateLine::ActionErase(CDC* pDC)
{
	if( m_bAction ){
		InvertLine(pDC,m_iX1,m_iY1,m_iX2,m_iY2);
		m_bAction = FALSE ;
	}
}

// Draw to the new position
void CIndecateLine::ActionDisplay(CPoint NewPoint,CDC* pDC)
{
	// Erase
	ActionErase(pDC);

	// Draw at new position
	m_iX2 = NewPoint.x ;
	m_iY2 = NewPoint.y ;
	InvertLine(pDC,m_iX1,m_iY1,m_iX2,m_iY2);
	m_bAction = TRUE ;
}


// Start Drawing
int  CIndecateLine::ActionDown(UINT nFlags, CPoint point,CDC* pDC)
{
	m_iX1 = point.x ;
	m_iY1 = point.y ;

	// Draw
	ActionDisplay(point,pDC) ;

	return( B_ActionContinue );	// Continue
}


// Move
int  CIndecateLine::ActionMove(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionDisplay(point,pDC) ;

	return( B_ActionContinue );	// Continue
}

// End
int  CIndecateLine::ActionUp(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionDisplay(point,pDC) ;

	ActionErase(pDC) ;

	return( B_ActionOk );
}

// Cancel
int  CIndecateLine::ActionCancel(CDC* pDC)
{
	ActionErase(pDC) ;

	return( B_ActionStop );
}
